% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vlmc.R
\name{cutoff}
\alias{cutoff}
\alias{cutoff.vlmc}
\title{Cut off values for pruning the context tree of a VLMC}
\usage{
cutoff(vlmc, mode = c("quantile", "native"), raw = FALSE, ...)

\method{cutoff}{vlmc}(vlmc, mode = c("quantile", "native"), raw = FALSE, ...)
}
\arguments{
\item{vlmc}{a fitted VLMC model.}

\item{mode}{specify whether the results should be "native" log likelihood ratio values
or expressed in a "quantile" scale of a chi-squared distribution (defaults to "quantile").}

\item{raw}{specify whether the returned values should be limit values computed in the model or
modified values that guarantee pruning (see details)}

\item{...}{additional arguments for the cutoff function.}
}
\value{
a vector of cut off values.
}
\description{
This function returns a collection of cut off values that are guaranteed to induce all
valid pruned trees of the context tree of a VLMC. Pruning is implemented by the \code{\link[=prune]{prune()}} function.
}
\details{
By default, the function returns values that can be used directly to
induce pruning in the context tree. This is done by computing the log likelihood ratios
used by the context algorithm on the reference VLMC and by keeping the relevant ones. From them
the function selects intermediate values that are guaranteed to generate via pruning
all the VLMC models that could be generated by using larger values of the \code{cutoff}
parameter that was used to build the reference model (or smaller values of the \code{alpha}
parameter in "quantile" scale).

Setting the \code{raw} parameter to \code{TRUE} removes this operation on the values and
asks the function to return the relevant log likelihood ratios.

As automated model selection is provided by \code{\link[=tune_vlmc]{tune_vlmc()}}, the direct use of \code{cutoff}
should be reserved to advanced exploration of the set of trees that can be
obtained from a complex one, e.g. to implement model selection techniques that
are not provided by \code{\link[=tune_vlmc]{tune_vlmc()}}.
}
\examples{
pc <- powerconsumption[powerconsumption$week == 5, ]
dts <- cut(pc$active_power, breaks = c(0, quantile(pc$active_power, probs = c(0.25, 0.5, 0.75, 1))))
model <- vlmc(dts)
draw(model)
model_cuts <- cutoff(model)
model_2 <- prune(model, model_cuts[2])
draw(model_2)
}
\seealso{
\code{\link[=prune]{prune()}} and \code{\link[=tune_vlmc]{tune_vlmc()}}
}
