% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_methods.R
\docType{methods}
\name{getMeanWeight}
\alias{getMeanWeight}
\alias{getMeanWeight,MizerSim-method}
\title{Calculate the mean weight of the community}
\usage{
getMeanWeight(object, ...)

\S4method{getMeanWeight}{MizerSim}(object,
  species = 1:nrow(object@params@species_params), ...)
}
\arguments{
\item{object}{An object of class \code{MizerSim}}

\item{...}{Other arguments for the \code{getN} and \code{getBiomass} methods suchs as \code{min_w}, \code{max_w} \code{min_l} and \code{max_l}.}

\item{species}{numeric or character vector of species to include in the calculation}
}
\value{
A vector containing the mean weight of the community through time
}
\description{
Calculates the mean weight of the community through time.
This is simply the total biomass of the community divided by the abundance in numbers.
You can specify minimum and maximum weight or length range for the species. Lengths take precedence over weights (i.e. if both min_l and min_w are supplied, only min_l will be used).
You can also specify the species to be used in the calculation.

Calculate the mean weight of the community from a \code{MizerSim} object.
}
\examples{
\dontrun{
data(NS_species_params_gears)
data(inter)
params <- MizerParams(NS_species_params_gears, inter)
sim <- project(params, effort=1, t_max=10)
getMeanWeight(sim)
getMeanWeight(sim, species=c("Herring","Sprat","N.pout"))
getMeanWeight(sim, min_w = 10, max_w = 5000)
}
}
