% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_methods.R
\docType{methods}
\name{getPhiPrey}
\alias{getPhiPrey}
\alias{getPhiPrey,MizerParams,matrix,numeric-method}
\title{Get available energy}
\usage{
getPhiPrey(object, n, n_pp, ...)

\S4method{getPhiPrey}{MizerParams,matrix,numeric}(object, n, n_pp, ...)
}
\arguments{
\item{object}{An \linkS4class{MizerParams} object}

\item{n}{A matrix of species abundances (species x size)}

\item{n_pp}{A vector of the background abundance by size}

\item{...}{Other arguments (currently unused)}
}
\value{
A two dimensional array (predator species x predator size)
}
\description{
Calculates the amount \eqn{E_{a,i}(w)} of food exposed to each predator as
a function of predator size.
}
\details{
This method is used by the \code{\link{project}} method for
performing simulations.
}
\examples{
\dontrun{
data(NS_species_params_gears)
data(inter)
params <- MizerParams(NS_species_params_gears, inter)
# With constant fishing effort for all gears for 20 time steps
sim <- project(params, t_max = 20, effort = 0.5)
n <- sim@n[21,,]
n_pp <- sim@n_pp[21,]
getPhiPrey(params,n,n_pp)
}
}
\seealso{
\code{\link{project}}
}
