% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_methods.R
\name{mizerFMort}
\alias{mizerFMort}
\title{Get the total fishing mortality rate from all fishing gears by time, species
and size needed to project standard mizer model}
\usage{
mizerFMort(params, n, n_pp, n_other, t, effort, e_growth, pred_mort, ...)
}
\arguments{
\item{params}{A \linkS4class{MizerParams} object}

\item{n}{A matrix of species abundances (species x size).}

\item{n_pp}{A vector of the resource abundance by size}

\item{n_other}{A list of abundances for other dynamical components of the
ecosystem}

\item{t}{The time for which to do the calculation (Not used by standard
mizer rate functions but useful for extensions with time-dependent
parameters.)}

\item{effort}{A vector with the effort for each fishing gear.}

\item{e_growth}{An array (species x size) with the energy available for
growth as calculated by \code{\link[=getEGrowth]{getEGrowth()}}. Unused.}

\item{pred_mort}{A two dimensional array (species x size) with the predation
mortality as calculated by \code{\link[=getPredMort]{getPredMort()}}. Unused.}

\item{...}{Unused}
}
\value{
An array (species x size) with the fishing mortality.
}
\description{
Calculates the total fishing mortality  (in units 1/year) from all gears by
species and size at each time step in the \code{effort} argument.
The total fishing mortality is just the sum of the fishing mortalities
imposed by each gear, \eqn{\mu_{f.i}(w)=\sum_g F_{g,i,w}}.
You would not usually call this
function directly but instead use \code{\link[=getFMort]{getFMort()}}, which then calls this
function unless an alternative function has been registered, see below.
}
\note{
Here: fishing mortality = catchability x selectivity x effort.
}
\section{Your own fishing mortality function}{

By default \code{\link[=getFMort]{getFMort()}} calls \code{\link[=mizerFMort]{mizerFMort()}}. However you can
replace this with your own alternative fishing mortality function. If
your function is called \code{"myFMort"} then you register it in a MizerParams
object \code{params} with\preformatted{params <- setRateFunction(params, "FMort", "myFMort")
}

Your function will then be called instead of \code{\link[=mizerFMort]{mizerFMort()}}, with the
same arguments.
}

\seealso{
Other mizer rate functions: 
\code{\link{mizerEGrowth}()},
\code{\link{mizerEReproAndGrowth}()},
\code{\link{mizerERepro}()},
\code{\link{mizerEncounter}()},
\code{\link{mizerFMortGear}()},
\code{\link{mizerFeedingLevel}()},
\code{\link{mizerMort}()},
\code{\link{mizerPredMort}()},
\code{\link{mizerPredRate}()},
\code{\link{mizerRDI}()},
\code{\link{mizerRates}()},
\code{\link{mizerResourceMort}()}
}
\concept{mizer rate functions}
