% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setFishing.R
\name{gear_params}
\alias{gear_params}
\alias{gear_params<-}
\title{Gear parameters}
\usage{
gear_params(params)

gear_params(params) <- value
}
\arguments{
\item{params}{A MizerParams object}

\item{value}{A data frame with the gear parameters.}
}
\description{
These functions allow you to get or set the gear parameters stored in
a MizerParams object. These are used by \code{\link[=setFishing]{setFishing()}} to set up the
selectivity and catchability and thus together with the fishing effort
determine the fishing mortality.
}
\details{
The \code{gear_params} data has one row for each gear-species pair and one
column for each parameter that determines how that gear interacts with that
species. For the details see \code{\link[=setFishing]{setFishing()}}.

If you change a gear parameter, this will be used to recalculate the
\code{selectivity} and \code{catchability} arrays by calling \code{\link[=setFishing]{setFishing()}},
unless you have protected these with comments.
}
\seealso{
\code{\link[=validGearParams]{validGearParams()}}

Other functions for setting parameters: 
\code{\link{resource_params}()},
\code{\link{setExtMort}()},
\code{\link{setFishing}()},
\code{\link{setInitialValues}()},
\code{\link{setInteraction}()},
\code{\link{setMaxIntakeRate}()},
\code{\link{setMetabolicRate}()},
\code{\link{setParams}()},
\code{\link{setPredKernel}()},
\code{\link{setReproduction}()},
\code{\link{setResource}()},
\code{\link{setSearchVolume}()},
\code{\link{species_params}()}
}
\concept{functions for setting parameters}
