% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setResource.R
\name{setResource}
\alias{setResource}
\alias{getResourceRate}
\alias{getResourceCapacity}
\alias{getResourceDynamics}
\title{Set up resource}
\usage{
setResource(
  params,
  resource_rate = NULL,
  comment_rate = "set manually",
  resource_capacity = NULL,
  comment_capacity = "set manually",
  r_pp = resource_params(params)[["r_pp"]],
  kappa = resource_params(params)[["kappa"]],
  lambda = resource_params(params)[["lambda"]],
  n = resource_params(params)[["n"]],
  w_pp_cutoff = resource_params(params)[["w_pp_cutoff"]],
  resource_dynamics = NULL,
  ...
)

getResourceRate(params)

getResourceCapacity(params)

getResourceDynamics(params)
}
\arguments{
\item{params}{A MizerParams object}

\item{resource_rate}{Optional. Vector of resource intrinsic birth rates}

\item{comment_rate}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
A string describing how the value for 'resource_rate' was obtained. This is
ignored if 'resource_rate' is not supplied or already has a comment
attribute.}

\item{resource_capacity}{Optional. Vector of resource intrinsic carrying
capacity}

\item{comment_capacity}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
A string describing how the value for 'resource_capacity' was obtained. This is
ignored if 'resource_capacity' is not supplied or already has a comment
attribute.}

\item{r_pp}{Coefficient of the intrinsic resource birth rate}

\item{kappa}{Coefficient of the intrinsic resource carrying capacity}

\item{lambda}{Scaling exponent of the intrinsic resource carrying capacity}

\item{n}{Allometric growth exponent for resource}

\item{w_pp_cutoff}{The upper cut off size of the resource spectrum.
Default is 10 g.}

\item{resource_dynamics}{Optional. Name of the function that determines the
resource dynamics by calculating the resource spectrum at the next time
step from the current state. You only need to specify this if you do not
want to use the default \code{\link[=resource_semichemostat]{resource_semichemostat()}}.}

\item{...}{Unused}
}
\value{
A MizerParams object with updated resource parameters. Because of the
way the R language works, \code{setResource()} does not make the changes to the
params object that you pass to it but instead returns a new params object.
So to affect the change you call the function in the form
\code{params <- setResource(params, ...)}.
}
\description{
Sets the intrinsic resource growth rate and the intrinsic resource carrying
capacity as well as the name of the function used to simulate the resource
dynamics
}
\section{Setting resource dynamics}{

By default, mizer uses a semichemostat model to describe the resource
dynamics in each size class independently. This semichemostat dynamics is implemented
by the function \code{\link[=resource_semichemostat]{resource_semichemostat()}}. You can change the
resource dynamics by writing your own function, modelled on
\code{\link[=resource_semichemostat]{resource_semichemostat()}}, and then passing the name of your
function in the \code{resource_dynamics} argument.

The \code{resource_rate} argument is a vector specifying the intrinsic resource
growth rate for each size class. If it is not supplied, then the intrinsic growth
rate \eqn{r(w)} at size \eqn{w}
is set to \deqn{r(w) = r_{pp}\, w^{n-1}.}{r(w) = r_pp w^{n-1}}
The values of \eqn{r_{pp}} and \eqn{n} are taken from the \code{r_pp}
and \code{n} arguments.

The \code{resource_capacity} argument is a vector specifying the intrinsic resource
carrying capacity for each size class. If it is not supplied, then the
intrinsic carrying capacity \eqn{c(w)} at size \eqn{w}
is set to \deqn{c(w) = \kappa\, w^{-\lambda}}{c(w) = \kappa w^{-\lambda}}
for all \eqn{w} less than \code{w_pp_cutoff} and zero for larger sizes.
The values of \eqn{\kappa} and \eqn{\lambda} are taken from the \code{kappa}
and \code{lambda} arguments.
}

\seealso{
\code{\link[=resource_params]{resource_params()}}

Other functions for setting parameters: 
\code{\link{gear_params}()},
\code{\link{resource_params}()},
\code{\link{setExtMort}()},
\code{\link{setFishing}()},
\code{\link{setInitialValues}()},
\code{\link{setInteraction}()},
\code{\link{setMaxIntakeRate}()},
\code{\link{setMetabolicRate}()},
\code{\link{setParams}()},
\code{\link{setPredKernel}()},
\code{\link{setReproduction}()},
\code{\link{setSearchVolume}()},
\code{\link{species_params}()}
}
\concept{functions for setting parameters}
