% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defaults_edition.R
\name{defaults_edition}
\alias{defaults_edition}
\title{Default editions}
\usage{
defaults_edition(edition = NULL)
}
\arguments{
\item{edition}{NULL or a numerical value.}
}
\value{
The current edition number.
}
\description{
Function to set and get which edition of default choices is being used.
}
\details{
The mizer functions for creating new models make a lot of choices for default
values for parameters that are not provided by the user. Sometimes we find
better ways to choose the defaults and update mizer accordingly. When we do
this, we will increase the edition number.

If you call \code{defaults_edition()} without an argument it returns the
currently active edition. Otherwise it sets the active edition to the
given value.

Users who want their existing code for creating models not to change
behaviour when run with future versions of mizer should explicitly set the
desired defaults edition at the top of their code.

The most recent edition is edition 2. It will become the default in the
next release. The current default is edition 1. The following defaults
are changed in edition 2:
\itemize{
\item catchability = 0.3 instead of 1
\item initial effort = 1 instead of 0
}
}
