% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.nlme.mmkin.R
\name{summary.nlme.mmkin}
\alias{summary.nlme.mmkin}
\alias{print.summary.nlme.mmkin}
\title{Summary method for class "nlme.mmkin"}
\usage{
\method{summary}{nlme.mmkin}(
  object,
  data = FALSE,
  verbose = FALSE,
  distimes = TRUE,
  alpha = 0.05,
  ...
)

\method{print}{summary.nlme.mmkin}(x, digits = max(3, getOption("digits") - 3), verbose = x$verbose, ...)
}
\arguments{
\item{object}{an object of class \link{nlme.mmkin}}

\item{data}{logical, indicating whether the full data should be included in
the summary.}

\item{verbose}{Should the summary be verbose?}

\item{distimes}{logical, indicating whether DT50 and DT90 values should be
included.}

\item{alpha}{error level for confidence interval estimation from the t
distribution}

\item{\dots}{optional arguments passed to methods like \code{print}.}

\item{x}{an object of class \link{summary.nlme.mmkin}}

\item{digits}{Number of digits to use for printing}
}
\value{
The summary function returns a list based on the \link{nlme} object
obtained in the fit, with at least the following additional components
\item{nlmeversion, mkinversion, Rversion}{The nlme, mkin and R versions used}
\item{date.fit, date.summary}{The dates where the fit and the summary were
produced}
\item{diffs}{The differential equations used in the degradation model}
\item{use_of_ff}{Was maximum or minimum use made of formation fractions}
\item{data}{The data}
\item{confint_trans}{Transformed parameters as used in the optimisation, with confidence intervals}
\item{confint_back}{Backtransformed parameters, with confidence intervals if available}
\item{ff}{The estimated formation fractions derived from the fitted
model.}
\item{distimes}{The DT50 and DT90 values for each observed variable.}
\item{SFORB}{If applicable, eigenvalues of SFORB components of the model.}
The print method is called for its side effect, i.e. printing the summary.
}
\description{
Lists model equations, initial parameter values, optimised parameters
for fixed effects (population), random effects (deviations from the
population mean) and residual error model, as well as the resulting
endpoints such as formation fractions and DT50 values. Optionally
(default is FALSE), the data are listed in full.
}
\examples{

# Generate five datasets following SFO kinetics
sampling_times = c(0, 1, 3, 7, 14, 28, 60, 90, 120)
dt50_sfo_in_pop <- 50
k_in_pop <- log(2) / dt50_sfo_in_pop
set.seed(1234)
k_in <- rlnorm(5, log(k_in_pop), 0.5)
SFO <- mkinmod(parent = mkinsub("SFO"))

pred_sfo <- function(k) {
  mkinpredict(SFO,
    c(k_parent = k),
    c(parent = 100),
    sampling_times)
}

ds_sfo_mean <- lapply(k_in, pred_sfo)
names(ds_sfo_mean) <- paste("ds", 1:5)

set.seed(12345)
ds_sfo_syn <- lapply(ds_sfo_mean, function(ds) {
  add_err(ds,
    sdfunc = function(value) sqrt(1^2 + value^2 * 0.07^2),
    n = 1)[[1]]
})

# Evaluate using mmkin and nlme
library(nlme)
f_mmkin <- mmkin("SFO", ds_sfo_syn, quiet = TRUE, error_model = "tc", cores = 1)
f_nlme <- nlme(f_mmkin)
summary(f_nlme, data = TRUE)

}
\author{
Johannes Ranke for the mkin specific parts
José Pinheiro and Douglas Bates for the components inherited from nlme
}
