% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/graphics.R
\name{plot.mldr}
\alias{plot.mldr}
\title{Generates graphic representations of an mldr object}
\usage{
\method{plot}{mldr}(x, type = "LC", labelCount, labelIndices, title = NULL,
  ...)
}
\arguments{
\item{x}{The mldr object whose features are to be drawn}

\item{type}{Indicates the type of plot to be produced. Possible types are:\itemize{
 \item \code{"LC"} Draws a circular plot with sectors representing each label
and links between them depicting label co-occurrences
 \item \code{"LH"} for label histogram
 \item \code{"LB"} for label bar plot
 \item \code{"CH"} for cardinality histogram
 \item \code{"AT"} for attributes by type pie chart
 \item \code{"LSH"} for labelset histogram
 \item \code{"LSB"} for labelset bar plot
 }}

\item{labelCount}{Samples the labels in the dataset to show information of only \code{labelCount} of them}

\item{labelIndices}{Establishes the labels to be shown in the plot}

\item{title}{A title to be shown above the plot. Defaults to the name of the dataset passed as first argument}

\item{...}{Additional parameters to be given to barplot, hist, etc.}
}
\description{
Generates graphic representations of an \code{mldr} object
}
\examples{
library(mldr)
\dontrun{
# Label concurrence plot
plot(genbase, type = "LC") # Plots all labels
plot(genbase) # Same as above
plot(genbase, title = "genbase dataset") # Changes the title
plot(genbase, labelCount = 10) # Randomly selects 10 labels to plot
plot(genbase, labelIndices = genbase$labels$index[1:10]) # Plots info of first 10 labels

# Label histogram plot
plot(emotions, type = "LH")

# Cardinality histogram plot
plot(emotions, type = "CH")

# Attributes by type
plot(emotions, type = "AT", cex = 0.85)

# Labelset histogram
plot(emotions, type = "LSH")
}
}

