% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.R
\name{boot}
\alias{boot}
\title{Bootstrap Confidence Intervals via Resampling}
\usage{
boot(x, y, func, reps, conf.int)
}
\arguments{
\item{x, y}{numeric vectors of data values}

\item{func}{specify \code{mlf} function}

\item{reps}{(optional) number of resamples. Defaults to 500}

\item{conf.int}{(optional) numeric value indicating level of confidence. Defaults to \code{0.90}.}
}
\description{
Provides nonparametric confidence intervals via percentile-based resampling for given \code{mlf} function.
}
\examples{
# Sample data
a <- rnorm(25, 80, 35)
b <- rnorm(25, 100, 50)

mlf::mic(a, b)
mlf::boot(a, b, mic)
}
