% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jointentropy.R
\name{jointentropy}
\alias{jointentropy}
\title{Joint Entropy}
\usage{
jointentropy(x, y, bins)
}
\arguments{
\item{x, y}{numeric or discrete data vectors}

\item{bins}{specify number of bins}
}
\description{
Estimated difference between two probability distributions.
}
\examples{
# Sample numeric vector
a <- rnorm(25, 80, 35)
b <- rnorm(25, 90, 35)
mlf::jointentropy(a, b, bins = 2)

# Sample discrete vector
a <- as.factor(c(1,1,2,2))
b <- as.factor(c(1,1,1,2))
mlf::jointentropy(a, b)
}
