% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-serve.R
\name{mlflow_rfunc_serve}
\alias{mlflow_rfunc_serve}
\title{Serve an RFunc MLflow Model}
\usage{
mlflow_rfunc_serve(model_path, run_uuid = NULL, host = "127.0.0.1",
  port = 8090, daemonized = FALSE, browse = !daemonized,
  restore = FALSE)
}
\arguments{
\item{model_path}{The path to the MLflow model, as a string.}

\item{run_uuid}{ID of run to grab the model from.}

\item{host}{Address to use to serve model, as a string.}

\item{port}{Port to use to serve model, as numeric.}

\item{daemonized}{Makes `httpuv` server daemonized so R interactive sessions
are not blocked to handle requests. To terminate a daemonized server, call
`httpuv::stopDaemonizedServer()` with the handle returned from this call.}

\item{browse}{Launch browser with serving landing page?}

\item{restore}{Should \code{mlflow_restore_snapshot()} be called before serving?}
}
\description{
Serves an RFunc MLflow model as a local web API.
}
\examples{
\dontrun{
library(mlflow)

# save simple model with constant prediction
mlflow_save_model(function(df) 1, "mlflow_constant")

# serve an existing model over a web interface
mlflow_rfunc_serve("mlflow_constant")

# request prediction from server
httr::POST("http://127.0.0.1:8090/predict/")
}
}
