% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{generate}
\alias{generate}
\alias{mp_data}
\title{Generates Data Sets Based on a \code{\link{mp_model}}}
\usage{
generate(model, n_within, n_between, ndata = 1, mechanism = NULL)
}
\arguments{
\item{model}{a \code{\link{mp_model}}.}

\item{n_within}{a single positive integer of the desired within cluster observations.}

\item{n_between}{a single positive integer of the desired between cluster observations.}

\item{ndata}{a single positive integer of the number of desired data sets.}

\item{mechanism}{a function for inducing missing data to the data set. If NULL it is ignored. See details below.}
}
\value{
For \code{ndata = 1} a single \code{\link{data.frame}} is returned.
The first variable is the cluster identifier labeled \verb{_id}.
This object is also of class \code{mp_data} which means that it was generated
based on a specified model.
If multiple data sets are requested then they will be contained in a \code{\link{list}}.
}
\description{
Generates data sets based on a \code{\link{mp_model}}.
These data sets will be returned as a \code{\link{data.frame}} and include the
solved parameters as an attribute to the \code{\link{data.frame}}.
}
\details{
Note that there must only be one global ICC in \code{\link{mp_model}}.

Use the \code{mechanism} argument to specify  missing data mechanisms. See \code{\link{mechanisms}}
for predefined missing data mechanisms for the outcome and examples using them.
When creating custom mechanisms care needs to be taken because it is considered for
advanced usage. This a argument expects a function with the \code{\link{mp_data}} as the input,
and the function should return the modified \code{\link{mp_data}}. Be careful when
using this because it allows you to modify the population parameters, which will
be incorrect. You should only induce missing data values on variables. Missing data
on the predictors will cause listwise deletion to be used, but missing data on the
outcome will be appropriate for MAR-based mechanisms. See examples below for an
example that generates MCAR data on the outcome. See \code{\link{parameters}}
to obtain the population parameters from each data set.
}
\examples{
# Create Model
model <- (
    outcome('Y')
    + within_predictor('X')
    + effect_size(icc = 0.1)
)
# Set seed
set.seed(198723)
# Create data set
model |> generate(5, 50) -> mydata

# Induce missing data with custom function
model |> generate(50, 5, mechanism = MCAR(0.25)) -> mydata_mcar

# Induce missing data with custom function
model |> generate(50, 5, mechanism = \(data) {
    # `data` will be the `mp_data` used
    within(data, {
        # MCAR Process
        Y <- ifelse(runif(NROW(data)) < 0.5, Y, NA)
    })
}) -> mydata_mcar_custom

}
