% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_profile.R
\name{plot_profile}
\alias{plot_profile}
\title{Plot Profile Data}
\usage{
plot_profile(
  site_nm,
  time_dt,
  type = "head",
  replicates = FALSE,
  position = NULL,
  file = NULL,
  ...
)
}
\arguments{
\item{site_nm}{'character' string.
Local site name for a MLMS well.}

\item{time_dt}{'POSIXct' or 'character' string.
Estimated field visit time, the closest time in the vector of field visit start times.
Note that water-quality samples may be collected up to one week after
the site visit for pressure profiling.}

\item{type}{'character' string.
Plot type, choose "head" for hydraulic head, "temp" for fluid temperature,
or a USGS 5-digit parameter code (\code{pcode} in the \code{\link{samples}} dataset).
Hydraulic head is plotted by default.}

\item{replicates}{'logical' flag.
Whether to include replicate pressure measurements.}

\item{position}{'character' string.
Location used to position the legend.
Choose a single keyword from the list
"bottomright", "bottom", "bottomleft", "left", "topleft", "top", "topright", "right" and "center".}

\item{file}{'character' string.
PDF file to send plot graphics.
Defaults to the active graphics window.}

\item{...}{Additional arguments to be passed to the \code{\link[grDevices:pdf]{pdf}} function.
Only relevant if the \code{file} argument is specified.}
}
\value{
Invisibly \code{NULL}
}
\description{
Plot pressure, temperature, or water-quality data for a site visit.
}
\examples{
site_nm <- "USGS 133"
time_dt <- "2008-08-27"
plot_profile(site_nm, time_dt, position = "topleft")

plot_profile(site_nm, time_dt, type = "temp")

plot_profile(site_nm, time_dt, type = "07000", position = "bottomright")

site_nm <- "USGS 131A"
time_dt <- "2012-10-24"
plot_profile(site_nm, time_dt)

plot_profile(site_nm, time_dt, type = "temp")

plot_profile(site_nm, time_dt, type = "07000")

file <- tempfile("test-profile-", fileext = ".pdf")
plot_profile(site_nm, time_dt, file = file, pointsize = 10)

unlink(file)
}
\seealso{
\code{\link{get_profile}} function is used to retrieve profile data.
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
