% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ports.R
\docType{data}
\name{ports}
\alias{ports}
\title{Measurement Ports}
\format{
A data frame with the following variables:
\describe{
\item{\code{site_nm}}{Local site name for a MLMS well.}
\item{\code{port_nu}}{Identifier for the valved measurement port.}
\item{\code{site_no}}{USGS site identification number.}
\item{\code{mp_a_va}}{Distance between the transducer plane and the bottom of the adjacent upper packer
(top of the monitoring zone), in feet, as documented in the system log.
A value of not applicable (\code{NA}) indicates a optional lower port coupling within the monitoring zone.}
\item{\code{wl_depth_va}}{Depth to water inside the multiport casing measured using an electric tape (e-tape),
in feet below the top of the well casing.}
\item{\code{baro_compl_va}}{Atmospheric pressure measured at land surface, in pounds per square inch (psi).}
\item{\code{temp_compl_va}}{Fluid temperature measured inside the multiport casing at the pressure transducer bridge,
in degrees Celsius (°C).}
\item{\code{press_compl_va}}{Absolute pressure of fluid inside the multiport casing, in psi.}
\item{\code{tp_depth_va}}{Depth to the transducer plane in the measurement port coupling,
in feet below land surface.}
\item{\code{port_depth_va}}{Depth to the measurement port inlet valve of a port coupling,
in ft bls.}
\item{\code{port_alt_va}}{Altitude of the measurement port inlet valve of a port coupling,
in feet above the North American Vertical Datum of 1988 (NAVD 88).}
\item{\code{zone_nu}}{Identifier for the depth-discrete monitoring zone,
where groundwater in this zone is vertically isolated between upper and lower packers.}
\item{\code{npress}}{Number of pressure and temperature measurements collected at the port.}
\item{\code{nsamples}}{Number of water-quality samples collected at the port.}
}
}
\source{
The dataset originates from the USGS INL Project Office
and underwent processing using the \code{\link{read_mlms_json}} function.
}
\usage{
ports
}
\description{
Dataset describing the locations of measurement ports within the
multilevel completions of wells in the U.S. Geological Survey (USGS) aquifer-monitoring network,
Idaho National Laboratory (INL), Idaho.
These valved measurement ports enable monitor groundwater outside the
multiport casing and within a monitoring zone.
}
\examples{
str(ports)
}
\keyword{datasets}
