% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dis_dtw_2.R
\encoding{UTF-8}
\name{dis_dtw_2}
\alias{dis_dtw_2}
\title{Constructs a pairwise distance matrix based on multivariate
dynamic time warping}
\usage{
dis_dtw_2(X, normalization = FALSE, ...)
}
\arguments{
\item{X}{A list of MTS (numerical matrices).}

\item{normalization}{Logical. If \code{normalization = TRUE} (default), the normalized
distance is computed. Otherwise (default), no normalization is taken into account}

\item{...}{Additional parameters for the function. See  \code{\link[dtw]{dtw}}.}
}
\value{
The computed pairwise distance matrix.
}
\description{
\code{dis_dtw1} returns a pairwise distance matrix based on one of the multivariate
extensions of the well-known dynamic time warping distance \insertCite{shokoohi2017generalizing}{mlmts}.
}
\details{
Given a collection of MTS, the function returns the pairwise distance matrix,
where the distance between two MTS is defined as the multivariate extension of the
dynamic time warping distance which forces all dimensions to warp identically,
in a single warping matrix.
}
\examples{
toy_dataset <- AtrialFibrillation$data[1 : 10] # Selecting the first 10 MTS from the
# dataset AtrialFibrillation
distance_matrix <- dis_dtw_2(toy_dataset) # Computing the pairwise
# distance matrix based on the distance dis_dtw1 without normalization
distance_matrix_normalized <- dis_dtw_2(toy_dataset, normalization = TRUE) # Computing the pairwise
# distance matrix based on the distance dis_dtw1 with normalization
}
\references{
{

  \insertRef{shokoohi2017generalizing}{mlmts}

}
}
\seealso{
\code{\link{dis_dtw_2}}, \code{\link{dis_mahalanobis_dtw}}
}
\author{
Ángel López-Oriona, José A. Vilar
}
