/**
 * @file src/krann.cpp
 *
 * This is an autogenerated file containing implementations of C++ functions to
 * be called by the R krann binding.
 */
#include <rcpp_mlpack.h>
#define BINDING_TYPE BINDING_TYPE_R
#include <mlpack/methods/rann/krann_main.cpp>

// [[Rcpp::export]]
void krann_mlpackMain()
{
  mlpackMain();
}

// Any implementations of methods for dealing with model pointers will be put
// below this comment, if needed.

// Get the pointer to a RANNModel parameter.
// [[Rcpp::export]]
SEXP IO_GetParamRANNModelPtr(const std::string& paramName)
{
  return std::move((Rcpp::XPtr<RANNModel>) IO::GetParam<RANNModel*>(paramName));
}

// Set the pointer to a RANNModel parameter.
// [[Rcpp::export]]
void IO_SetParamRANNModelPtr(const std::string& paramName, SEXP ptr)
{
  IO::GetParam<RANNModel*>(paramName) =  Rcpp::as<Rcpp::XPtr<RANNModel>>(ptr);
  IO::SetPassed(paramName);
}

// Serialize a RANNModel pointer.
// [[Rcpp::export]]
Rcpp::RawVector SerializeRANNModelPtr(SEXP ptr)
{
  std::ostringstream oss;
  {
    boost::archive::binary_oarchive oa(oss);
    oa << boost::serialization::make_nvp("RANNModel",
          *Rcpp::as<Rcpp::XPtr<RANNModel>>(ptr));
  }

  Rcpp::RawVector raw_vec(oss.str().size());

  // Copy the string buffer so we can return one that won't get deallocated when
  // we exit this function.
  memcpy(&raw_vec[0], oss.str().c_str(), oss.str().size());
  raw_vec.attr("type") = "RANNModel";
  return raw_vec;
}

// Deserialize a RANNModel pointer.
// [[Rcpp::export]]
SEXP DeserializeRANNModelPtr(Rcpp::RawVector str)
{
  RANNModel* ptr = new RANNModel();

  std::istringstream iss(std::string((char *) &str[0], str.size()));
  {
    boost::archive::binary_iarchive ia(iss);
    ia >> boost::serialization::make_nvp("RANNModel", *ptr);
  }

  // R will be responsible for freeing this.
  return std::move((Rcpp::XPtr<RANNModel>)ptr);
}


