/**
 * @file src/lars.cpp
 *
 * This is an autogenerated file containing implementations of C++ functions to
 * be called by the R lars binding.
 */
#include <rcpp_mlpack.h>
#define BINDING_TYPE BINDING_TYPE_R
#include <mlpack/methods/lars/lars_main.cpp>

// [[Rcpp::export]]
void lars_mlpackMain()
{
  mlpackMain();
}

// Any implementations of methods for dealing with model pointers will be put
// below this comment, if needed.

// Get the pointer to a LARS parameter.
// [[Rcpp::export]]
SEXP IO_GetParamLARSPtr(const std::string& paramName)
{
  return std::move((Rcpp::XPtr<LARS>) IO::GetParam<LARS*>(paramName));
}

// Set the pointer to a LARS parameter.
// [[Rcpp::export]]
void IO_SetParamLARSPtr(const std::string& paramName, SEXP ptr)
{
  IO::GetParam<LARS*>(paramName) =  Rcpp::as<Rcpp::XPtr<LARS>>(ptr);
  IO::SetPassed(paramName);
}

// Serialize a LARS pointer.
// [[Rcpp::export]]
Rcpp::RawVector SerializeLARSPtr(SEXP ptr)
{
  std::ostringstream oss;
  {
    boost::archive::binary_oarchive oa(oss);
    oa << boost::serialization::make_nvp("LARS",
          *Rcpp::as<Rcpp::XPtr<LARS>>(ptr));
  }

  Rcpp::RawVector raw_vec(oss.str().size());

  // Copy the string buffer so we can return one that won't get deallocated when
  // we exit this function.
  memcpy(&raw_vec[0], oss.str().c_str(), oss.str().size());
  raw_vec.attr("type") = "LARS";
  return raw_vec;
}

// Deserialize a LARS pointer.
// [[Rcpp::export]]
SEXP DeserializeLARSPtr(Rcpp::RawVector str)
{
  LARS* ptr = new LARS();

  std::istringstream iss(std::string((char *) &str[0], str.size()));
  {
    boost::archive::binary_iarchive ia(iss);
    ia >> boost::serialization::make_nvp("LARS", *ptr);
  }

  // R will be responsible for freeing this.
  return std::move((Rcpp::XPtr<LARS>)ptr);
}


