% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmark.R
\name{BenchmarkResult}
\alias{BenchmarkResult}
\title{BenchmarkResult object.}
\description{
Result of a benchmark experiment conducted by \link{benchmark}
with the following members:
\describe{
\item{results (list of \link{ResampleResult}):}{
A nested \link{list} of resample results,
first ordered by task id, then by learner id.
}
\item{measures (list of \link{Measure}):}{
The performance measures used in the benchmark experiment.
}
\item{learners (list of \link{Learner}):}{
The learning algorithms compared in the benchmark experiment.
}
}

The print method of this object shows aggregated performance values
for all tasks and learners.

It is recommended to
retrieve required information via the \code{getBMR*} getter functions.
You can also convert the object using \link{as.data.frame}.
}
\seealso{
Other benchmark: \code{\link{batchmark}},
  \code{\link{benchmark}},
  \code{\link{convertBMRToRankMatrix}},
  \code{\link{friedmanPostHocTestBMR}},
  \code{\link{friedmanTestBMR}},
  \code{\link{generateCritDifferencesData}},
  \code{\link{getBMRAggrPerformances}},
  \code{\link{getBMRFeatSelResults}},
  \code{\link{getBMRFilteredFeatures}},
  \code{\link{getBMRLearnerIds}},
  \code{\link{getBMRLearnerShortNames}},
  \code{\link{getBMRLearners}},
  \code{\link{getBMRMeasureIds}},
  \code{\link{getBMRMeasures}}, \code{\link{getBMRModels}},
  \code{\link{getBMRPerformances}},
  \code{\link{getBMRPredictions}},
  \code{\link{getBMRTaskDescs}},
  \code{\link{getBMRTaskIds}},
  \code{\link{getBMRTuneResults}},
  \code{\link{plotBMRBoxplots}},
  \code{\link{plotBMRRanksAsBarChart}},
  \code{\link{plotBMRSummary}},
  \code{\link{plotCritDifferences}},
  \code{\link{reduceBatchmarkResults}}
}
