% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DummyFeaturesWrapper.R
\name{makeDummyFeaturesWrapper}
\alias{makeDummyFeaturesWrapper}
\title{Fuse learner with dummy feature creator.}
\usage{
makeDummyFeaturesWrapper(learner, method = "1-of-n", cols = NULL)
}
\arguments{
\item{learner}{(\link{Learner} | \code{character(1)})\cr
The learner.
If you pass a string the learner will be created via \link{makeLearner}.}

\item{method}{(\code{character(1)})\cr
Available are:
\describe{
\item{"1-of-n":}{For n factor levels there will be n dummy variables.}
\item{"reference":}{There will be n-1 dummy variables leaving out the first factor level of each variable.}
}
Default is \dQuote{1-of-n}.}

\item{cols}{(\link{character})\cr
Columns to create dummy features for. Default is to use all columns.}
}
\value{
\link{Learner}.
}
\description{
Fuses a base learner with the dummy feature creator (see \link{createDummyFeatures}).
Returns a learner which can be used like any other learner.
}
\seealso{
Other wrapper: \code{\link{makeBaggingWrapper}},
  \code{\link{makeClassificationViaRegressionWrapper}},
  \code{\link{makeConstantClassWrapper}},
  \code{\link{makeCostSensClassifWrapper}},
  \code{\link{makeCostSensRegrWrapper}},
  \code{\link{makeDownsampleWrapper}},
  \code{\link{makeExtractFDAFeatsWrapper}},
  \code{\link{makeFeatSelWrapper}},
  \code{\link{makeFilterWrapper}},
  \code{\link{makeImputeWrapper}},
  \code{\link{makeMulticlassWrapper}},
  \code{\link{makeMultilabelBinaryRelevanceWrapper}},
  \code{\link{makeMultilabelClassifierChainsWrapper}},
  \code{\link{makeMultilabelDBRWrapper}},
  \code{\link{makeMultilabelNestedStackingWrapper}},
  \code{\link{makeMultilabelStackingWrapper}},
  \code{\link{makeOverBaggingWrapper}},
  \code{\link{makePreprocWrapperCaret}},
  \code{\link{makePreprocWrapper}},
  \code{\link{makeRemoveConstantFeaturesWrapper}},
  \code{\link{makeSMOTEWrapper}},
  \code{\link{makeTuneWrapper}},
  \code{\link{makeUndersampleWrapper}},
  \code{\link{makeWeightedClassesWrapper}}
}
