% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateThreshVsPerf.R
\name{plotThreshVsPerf}
\alias{plotThreshVsPerf}
\title{Plot threshold vs. performance(s) for 2-class classification using ggplot2.}
\usage{
plotThreshVsPerf(obj, measures = obj$measures, facet = "measure",
  mark.th = NA_real_, pretty.names = TRUE, facet.wrap.nrow = NULL,
  facet.wrap.ncol = NULL)
}
\arguments{
\item{obj}{(\link{ThreshVsPerfData})\cr
Result of \link{generateThreshVsPerfData}.}

\item{measures}{(\link{Measure} | list of \link{Measure})\cr
Performance measure(s) to plot.
Must be a subset of those used in \link{generateThreshVsPerfData}.
Default is all the measures stored in \code{obj} generated by
\link{generateThreshVsPerfData}.}

\item{facet}{(\code{character(1)})\cr
Selects \dQuote{measure} or \dQuote{learner} to be the facetting variable.
The variable mapped to \code{facet} must have more than one unique value, otherwise it will
be ignored. The variable not chosen is mapped to color if it has more than one unique value.
The default is \dQuote{measure}.}

\item{mark.th}{(\code{numeric(1)})\cr
Mark given threshold with vertical line?
Default is \code{NA} which means not to do it.}

\item{pretty.names}{(\code{logical(1)})\cr
Whether to use the \link{Measure} name instead of the id in the plot.
Default is \code{TRUE}.}

\item{facet.wrap.nrow, facet.wrap.ncol}{(\link{integer})\cr
Number of rows and columns for facetting. Default for both is \code{NULL}.
In this case ggplot's \code{facet_wrap} will choose the layout itself.}
}
\value{
ggplot2 plot object.
}
\description{
Plots threshold vs. performance(s) data that has been generated with \link{generateThreshVsPerfData}.
}
\examples{
lrn = makeLearner("classif.rpart", predict.type = "prob")
mod = train(lrn, sonar.task)
pred = predict(mod, sonar.task)
pvs = generateThreshVsPerfData(pred, list(acc, setAggregation(acc, train.mean)))
plotThreshVsPerf(pvs)
}
\seealso{
Other plot: \code{\link{createSpatialResamplingPlots}},
  \code{\link{plotBMRBoxplots}},
  \code{\link{plotBMRRanksAsBarChart}},
  \code{\link{plotBMRSummary}},
  \code{\link{plotCalibration}},
  \code{\link{plotCritDifferences}},
  \code{\link{plotLearningCurve}},
  \code{\link{plotPartialDependence}},
  \code{\link{plotROCCurves}}, \code{\link{plotResiduals}}

Other thresh_vs_perf: \code{\link{generateThreshVsPerfData}},
  \code{\link{plotROCCurves}}
}
\concept{plot}
\concept{thresh_vs_perf}
