% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuneThreshold.R
\name{tuneThreshold}
\alias{tuneThreshold}
\title{Tune prediction threshold.}
\usage{
tuneThreshold(pred, measure, task, model, nsub = 20L, control = list())
}
\arguments{
\item{pred}{[\code{\link{Prediction}}]\cr
Prediction object.}

\item{measure}{[\code{\link{Measure}}]\cr
Performance measure to optimize.
Default is the default measure for the task.}

\item{task}{[\code{\link{Task}}]\cr
Learning task. Rarely neeeded,
only when required for the performance measure.}

\item{model}{[\code{\link{WrappedModel}}]\cr
Fitted model. Rarely neeeded,
only when required for the performance measure.}

\item{nsub}{[\code{integer(1)}]\cr
Passed to \code{\link[BBmisc]{optimizeSubInts}} for 2class problems.
Default is 20.}

\item{control}{[\code{list}]\cr
Control object for \code{\link[cmaes]{cma_es}} when used.
Default is empty list.}
}
\value{
[\code{list}]. A named list with with the following components:
  \code{th} is the optimal threshold, \code{perf} the performance value.
}
\description{
Optimizes the threshold of predictions based on probabilities.
Works for classification and multilabel tasks.
Uses \code{\link[BBmisc]{optimizeSubInts}} for normal binary class problems and \code{\link[cmaes]{cma_es}}
for multiclass and multilabel problems.
}
\seealso{
Other tune: \code{\link{TuneControl}},
  \code{\link{getNestedTuneResultsOptPathDf}},
  \code{\link{getNestedTuneResultsX}},
  \code{\link{getTuneResult}},
  \code{\link{makeModelMultiplexerParamSet}},
  \code{\link{makeModelMultiplexer}},
  \code{\link{makeTuneWrapper}}, \code{\link{tuneParams}}
}

