% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reports.R
\name{report_datasheet}
\alias{report_datasheet}
\title{Create a Datasheet for Documenting a Dataset}
\usage{
report_datasheet(filename = "datasheet.Rmd", edit = FALSE, build = FALSE)
}
\arguments{
\item{filename}{(\code{character(1)})\cr
File path or name for new file that should be created.}

\item{edit}{(\code{logical(1)})\cr
\code{TRUE} to edit the template immediately.}

\item{build}{(\code{logical(1)})\cr
Should the report be built after creation? Initialized to \code{FALSE}.}
}
\value{
Invisibly returns the path to the newly created file(s).
}
\description{
Creates a new \CRANpkg{rmarkdown} template with a skeleton questionnaire for dataset documentation.
Uses the awesome markdown template created by Chris Garbin
\href{https://github.com/fau-masters-collected-works-cgarbin/model-card-template}{from Github}.
}
\examples{
  report_file = tempfile()
  report_datasheet(report_file)
}
\references{
Gebru, Timnit, Morgenstern, Jamie, Vecchione, Briana, Vaughan, Wortman J, Wallach, Hanna, III D, Hal, Crawford, Kate (2018).
\dQuote{Datasheets for datasets.}
\emph{arXiv preprint arXiv:1803.09010}.
}
\seealso{
Other fairness_reports: 
\code{\link{report_fairness}()},
\code{\link{report_modelcard}()}
}
\concept{fairness_reports}
