test_that("model cards", {
  skip_on_cran()
  skip_if_not_installed("rmarkdown")
  skip_if_not_installed("posterdown")
  skip_if_not(rmarkdown::pandoc_available())
  tmp = tempdir()
  tmp = paste0(tmp, "/report")
  unlink(tmp, recursive = TRUE)
  report_modelcard(tmp, edit = FALSE)
  expect_true(all(list.files(tmp) %in% c("references.bib", "style.css", paste0(basename(tmp), ".Rmd"), "LICENSE")))
  out = rmarkdown::render(paste0(tmp, "/", basename(tmp),  ".Rmd"), quiet = TRUE)
  expect_character(out)
  expect_true(readLines(out)[1] == "<!DOCTYPE html>")
  unlink(tmp, recursive = TRUE)
})

test_that("datasheets", {
  skip_on_cran()
  skip_if_not_installed("rmarkdown")
  skip_if_not_installed("posterdown")
  skip_if_not(rmarkdown::pandoc_available())
  tmp = tempdir()
  tmp = paste0(tmp, "/report")
  unlink(tmp, recursive = TRUE)
  report_datasheet(tmp, edit = FALSE)
  expect_true(all(list.files(tmp) %in% c("references.bib", "style.css", paste0(basename(tmp), ".Rmd"), "LICENSE")))
  out = rmarkdown::render(paste0(tmp, "/", basename(tmp),  ".Rmd"), quiet = TRUE)
  expect_character(out)
  expect_true(readLines(out)[1] == "<!DOCTYPE html>")
  unlink(tmp, recursive = TRUE)
})

test_that("fairness_report", {
  skip_on_cran()
  skip_if_not_installed("rmarkdown")
  skip_if_not_installed("kableExtra")
  skip_if_not(rmarkdown::pandoc_available())
  tmp = tempdir()
  tmp = paste0(tmp, "/report")
  unlink(tmp, recursive = TRUE)
  task = suppressWarnings(tsk("compas")$filter(1:500)$select(c("age", "decile_score","race", "sex", "c_charge_degree")))
  learner = lrn("classif.rpart", predict_type = "prob")
  rr = resample(task, learner, rsmp("cv", folds = 5))
  report_fairness(tmp, list(task = task, resample_result = rr, foo = 1))
  expect_true(all(c("references.bib", paste0(basename(tmp), ".Rmd")) %in% list.files(tmp)))
  out = suppressWarnings(rmarkdown::render(paste0(tmp, "/", basename(tmp),  ".Rmd"), quiet = TRUE))
  expect_character(out)
  expect_true(readLines(out)[1] == "<!DOCTYPE html>")
  unlink(tmp, recursive = TRUE)
})
