% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_hash.R
\name{calculate_hash}
\alias{calculate_hash}
\title{Calculate a Hash for Multiple Objects}
\usage{
calculate_hash(...)
}
\arguments{
\item{...}{(any)\cr
Objects to hash.}
}
\value{
(\code{character(1)}).
}
\description{
Calls \code{\link[digest:digest]{digest::digest()}} to calculate the hash for all objects provided.

The following operations are performed to make hashing more robust:
\itemize{
\item If an object is a \code{\link[=function]{function()}}, the formals and the body are hashed separately.
This ensures that the bytecode or parent environment are not be included
in the hash.
\item If an object is a \code{\link[data.table:data.table]{data.table::data.table()}}, the data.table is converted to a
regular list. This ensures that keys and indices are not included in the hash.
}

Note that this only applies to top level objects, these transformations are not done
recursively.
}
\examples{
calculate_hash(iris, 1, "a")
}
