% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OMLRun.R
\name{oml_run_r6}
\alias{oml_run_r6}
\alias{OMLRun}
\title{Interface to OpenML Runs}
\description{
This is the class for OpenML \href{https://www.openml.org/r}{Runs}, which are
conceptually similar to \link[mlr3:ResampleResult]{mlr3::ResampleResult}s.
This object can also be constructed using the sugar function \code{\link[=oml_run]{oml_run()}}.
}
\section{OpenML Integration}{

\itemize{
\item A \link{OMLTask} is returned by accessing the active field \verb{$task}.
\item A \link{OMLData} is returned by accessing the active field \verb{$data} (short for \verb{$task$data})
\item A \link{OMLFlow} is returned by accessing the active field \verb{$flow}.
\item The raw predictions are returned by accessing the active field \verb{$prediction}.
}
}

\section{mlr3 Integration}{

\itemize{
\item A \link[mlr3:ResampleResult]{mlr3::ResampleResult} is returned when calling \code{\link[mlr3:as_resample_result]{mlr3::as_resample_result()}}.
\item A \link[mlr3:Task]{mlr3::Task} is returned when calling \code{\link[mlr3:as_task]{mlr3::as_task()}}.
\item A \link[mlr3:DataBackend]{mlr3::DataBackend} is returned when calling \code{\link[mlr3:as_data_backend]{mlr3::as_data_backend()}}.
\item A instantiated \link[mlr3:Resampling]{mlr3::Resampling} is returned when calling \code{\link[mlr3:as_resampling]{mlr3::as_resampling()}}.
}
}

\examples{
\donttest{
library("mlr3")
orun = OMLRun$new(id = 10587724)
# sugar
orun = oml_run(id = 10587724)
print(orun)
print(orun$task) # OMLTask
print(orun$data) # OMLData
print(orun$flow) # OMLFlow
print(orun$prediction)
as_task(orun)
as_resampling(orun)
as_data_backend(orun)
rr = as_resample_result(orun)
rr$score(msr("classif.ce"))
}
}
\references{
Vanschoren J, van Rijn JN, Bischl B, Torgo L (2014).
\dQuote{OpenML.}
\emph{ACM SIGKDD Explorations Newsletter}, \bold{15}(2), 49--60.
\doi{10.1145/2641190.2641198}.
}
\section{Super class}{
\code{\link[mlr3oml:OMLObject]{mlr3oml::OMLObject}} -> \code{OMLRun}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{flow_id}}{(\code{integer(1)})\cr
The id of the flow.}

\item{\code{flow}}{(\link{OMLFlow})\cr
The OpenML Flow.}

\item{\code{tags}}{(\code{character()})\cr
Returns all tags of the object.}

\item{\code{parquet}}{(\code{logical(1)})\cr
Whether to use parquet.}

\item{\code{task_id}}{(\code{character(1)})\cr
The id of the task solved by this run.}

\item{\code{task}}{(\link{OMLTask})\cr
The task solved by this run.}

\item{\code{data_id}}{(\code{integer(1)})\cr
The id of the dataset.}

\item{\code{data}}{(\link{OMLData}) \cr
The data used in this run.}

\item{\code{task_type}}{(\code{character()})\cr
The task type.}

\item{\code{parameter_setting}}{\code{data.table()})\cr
The parameter setting for this run.}

\item{\code{prediction}}{(\code{data.table()})\cr
The raw predictions of the run as returned by OpenML, not in standard mlr3 format.
Formatted predictions are accessible after converting to a \link[mlr3:ResampleResult]{mlr3::ResampleResult} via
\code{as_resample_result()}.}

\item{\code{evaluation}}{(\code{data.table()})\cr
The evaluations calculated by the OpenML server.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OMLRun-new}{\code{OMLRun$new()}}
\item \href{#method-OMLRun-print}{\code{OMLRun$print()}}
\item \href{#method-OMLRun-clone}{\code{OMLRun$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3oml" data-topic="OMLObject" data-id="help"><a href='../../mlr3oml/html/OMLObject.html#method-OMLObject-help'><code>mlr3oml::OMLObject$help()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OMLRun-new"></a>}}
\if{latex}{\out{\hypertarget{method-OMLRun-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OMLRun$new(
  id,
  cache = cache_default(),
  parquet = parquet_default(),
  test_server = test_server_default()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{integer(1)})\cr
OpenML id for the object.}

\item{\code{cache}}{(\code{logical(1)} | \code{character(1)})\cr
See field \code{cache} for an explanation of possible values.
Defaults to value of option \code{"mlr3oml.cache"}, or \code{FALSE} if not set.}

\item{\code{parquet}}{(\code{logical(1)})\cr
Whether to use parquet instead of arff.
If parquet is not available, it will fall back to arff.
Defaults to value of option \code{"mlr3oml.parquet"} or \code{FALSE} if not set.}

\item{\code{test_server}}{(\code{character(1)})\cr
Whether to use the OpenML test server (https://test.openml.org/) or public server
(https://www.openml.org/).
Defaults to value of option \code{"mlr3oml.test_server"}, or \code{FALSE} if not set.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OMLRun-print"></a>}}
\if{latex}{\out{\hypertarget{method-OMLRun-print}{}}}
\subsection{Method \code{print()}}{
Prints the object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OMLRun$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OMLRun-clone"></a>}}
\if{latex}{\out{\hypertarget{method-OMLRun-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OMLRun$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
