% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpCrankCompositor.R
\name{mlr_pipeops_compose_crank}
\alias{mlr_pipeops_compose_crank}
\alias{PipeOpCrankCompositor}
\title{PipeOpCrankCompositor}
\description{
Uses a predicted \code{distr} in a \link{PredictionSurv} to estimate (or 'compose') a \code{crank} prediction.
}
\section{Dictionary}{

This \link[mlr3pipelines:PipeOp]{PipeOp} can be instantiated via the
\link[mlr3misc:Dictionary]{dictionary} \link[mlr3pipelines:mlr_pipeops]{mlr3pipelines::mlr_pipeops} or with the associated sugar
function \code{\link[mlr3pipelines:po]{mlr3pipelines::po()}}:\preformatted{PipeOpCrankCompositor$new()
mlr_pipeops$get("crankcompose")
po("crankcompose")
}
}

\section{Input and Output Channels}{

\link{PipeOpCrankCompositor} has one input channel named "input", which takes
\code{NULL} during training and \link{PredictionSurv} during prediction.

\link{PipeOpCrankCompositor} has one output channel named "output", producing \code{NULL} during training
and a \link{PredictionSurv} during prediction.

The output during prediction is the \link{PredictionSurv} from the "pred" input but with the \code{crank}
predict type overwritten by the given estimation method.
}

\section{State}{

The \verb{$state} is left empty (\code{list()}).
}

\section{Parameters}{

\itemize{
\item \code{method} :: \code{character(1)} \cr
Determines what method should be used to produce a continuous ranking from the distribution.
One of \code{median}, \code{mode}, or \code{mean} corresponding to the respective functions in the predicted
survival distribution. Note that for models with a proportional hazards form, the ranking
implied by \code{mean} and \code{median} will be identical (but not the value of \code{crank} itself).
Default is \code{mean}.
\item \code{which} :: \code{numeric(1)}\cr
If \code{method = "mode"} then specifies which mode to use if multi-modal, default is the first.
\item \code{response} :: \code{logical(1)}\cr
If \code{TRUE} then the \code{response} predict type is estimated with the same values as \code{crank}.
\item \code{overwrite} :: \code{logical(1)} \cr
If \code{FALSE} (default) then if the "pred" input already has a \code{crank}, the compositor only
composes a \code{response} type if \code{response = TRUE} and does not already exist. If \code{TRUE} then
both the \code{crank} and \code{response} are overwritten.
}
}

\section{Internals}{

The \code{median}, \code{mode}, or \code{mean} will use analytical expressions if possible but if not they are
calculated using methods from \CRANpkg{distr6}. \code{mean} requires \CRANpkg{cubature}.
}

\examples{
\dontrun{
if (requireNamespace("mlr3pipelines", quietly = TRUE)) {
  library(mlr3)
  library(mlr3pipelines)
  task = tsk("rats")

  learn = lrn("surv.coxph")$train(task)$predict(task)
  poc = po("crankcompose", param_vals = list(method = "median"))
  poc$predict(list(learn))[[1]]

  if (requireNamespace("cubature", quietly = TRUE)) {
    learn = lrn("surv.coxph")$train(task)$predict(task)
    poc = po("crankcompose", param_vals = list(method = "mean"))
    poc$predict(list(learn))[[1]]
  }
}
}
}
\seealso{
\link{pipeline_crankcompositor}

Other survival compositors: 
\code{\link{mlr_pipeops_compose_distr}}
}
\concept{survival compositors}
\section{Super class}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{PipeOpCrankCompositor}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{PipeOpCrankCompositor$new()}}
\item \href{#method-clone}{\code{PipeOpCrankCompositor$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict">}\href{../../mlr3pipelines/html/PipeOp.html#method-predict}{\code{mlr3pipelines::PipeOp$predict()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print">}\href{../../mlr3pipelines/html/PipeOp.html#method-print}{\code{mlr3pipelines::PipeOp$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train">}\href{../../mlr3pipelines/html/PipeOp.html#method-train}{\code{mlr3pipelines::PipeOp$train()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpCrankCompositor$new(
  id = "compose_crank",
  param_vals = list(method = "mean", response = FALSE, overwrite = FALSE)
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier of the resulting  object.}

\item{\code{param_vals}}{(\code{list()})\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would
otherwise be set during construction.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpCrankCompositor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
