% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipelines.R
\name{mlr_graphs_crankcompositor}
\alias{mlr_graphs_crankcompositor}
\alias{pipeline_crankcompositor}
\alias{crankcompositor}
\title{Estimate Survival crank Predict Type Pipeline}
\usage{
pipeline_crankcompositor(
  learner,
  method = c("sum_haz", "mean", "median", "mode"),
  which = NULL,
  response = FALSE,
  overwrite = FALSE,
  graph_learner = FALSE
)

crankcompositor(...)
}
\arguments{
\item{learner}{\verb{[mlr3::Learner]|[mlr3pipelines::PipeOp]|[mlr3pipelines::Graph]} \cr
Either a \code{Learner} which will be wrapped in \link[mlr3pipelines:mlr_pipeops_learner]{mlr3pipelines::PipeOpLearner}, a \code{PipeOp} which will
be wrapped in \link[mlr3pipelines:Graph]{mlr3pipelines::Graph} or a \code{Graph} itself. Underlying \code{Learner} should be
\link{LearnerSurv}.}

\item{method}{\code{character(1)}\cr
One of \code{sum_haz} (default), \code{mean}, \code{mode}, or \code{median};
abbreviations allowed. Used to determine how \code{crank} is estimated from
the predicted \code{distr}.}

\item{which}{\code{integer(1)}\cr
If \code{method = "mode"} then specifies which mode to use if multi-modal, default
is the first.}

\item{response}{\code{logical(1)}\cr
If \code{TRUE} then the \code{response} predict type is also estimated with the same values as \code{crank}.}

\item{overwrite}{\code{logical(1)}\cr
If \code{TRUE} then existing \code{response} and \code{crank} predict types are overwritten.}

\item{graph_learner}{\code{logical(1)}\cr
If \code{TRUE} returns wraps the \link[mlr3pipelines:Graph]{Graph} as a
\link[mlr3pipelines:mlr_learners_graph]{GraphLearner} otherwise (default) returns as a \code{Graph}.}

\item{...}{\code{ANY}\cr
For use with \code{crankcompositor}, now deprecated.}
}
\value{
\link[mlr3pipelines:Graph]{mlr3pipelines::Graph} or \link[mlr3pipelines:mlr_learners_graph]{mlr3pipelines::GraphLearner}
}
\description{
Wrapper around \link{PipeOpCrankCompositor} to simplify \link[mlr3pipelines:Graph]{Graph} creation.
}
\examples{
\dontrun{
if (requireNamespace("mlr3pipelines", quietly = TRUE)) {
  library("mlr3")
  library("mlr3pipelines")

  task = tsk("rats")
  pipe = ppl(
    "crankcompositor",
    learner = lrn("surv.coxph"),
    method = "sum_haz"
  )
  pipe$train(task)
  pipe$predict(task)
}
}
}
\seealso{
Other pipelines: 
\code{\link{mlr_graphs_distrcompositor}},
\code{\link{mlr_graphs_probregrcompositor}},
\code{\link{mlr_graphs_survaverager}},
\code{\link{mlr_graphs_survbagging}},
\code{\link{mlr_graphs_survtoregr}}
}
\concept{pipelines}
