% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{setCPOId}
\alias{setCPOId}
\title{Set the ID of a CPO Object}
\usage{
setCPOId(cpo, id)
}
\arguments{
\item{cpo}{[\code{\link{CPO}}]\cr
The cpo.}

\item{id}{[\code{character(1)} | \code{NULL}]\cr
The ID. If this is \code{NULL}, the ID is set to the
default for the CPO at hand, which is the CPO \dQuote{name}, see \code{\link{getCPOName}}.}
}
\value{
[\code{CPO}] the CPO with modified id.
}
\description{
Sets the \emph{id} of a \code{\link{CPO}}. Setting the id
is also possible during construction by a \code{\link{CPOConstructor}}
using the \code{id} parameter.

The exported hyperparameters of a CPO will all have the
id as prefix. This makes it possible to
compose CPOs that have clashing parameter names.
}
\seealso{
Other getters and setters: \code{\link{CPO}},
  \code{\link{getCPOAffect}}, \code{\link{getCPOClass}},
  \code{\link{getCPOConstructor}}, \code{\link{getCPOId}},
  \code{\link{getCPOName}},
  \code{\link{getCPOOperatingType}},
  \code{\link{getCPOPredictType}},
  \code{\link{getCPOProperties}},
  \code{\link{getCPOTrainedCPO}},
  \code{\link{getCPOTrainedCapability}}

Other CPO ID related: \code{\link{getCPOId}}
}
\concept{CPO ID related}
\concept{getters and setters}
