% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setMBOControlInfill.R
\name{setMBOControlInfill}
\alias{setMBOControlInfill}
\title{Extends mbo control object with infill criteria and infill optimizer options.}
\usage{
setMBOControlInfill(control, crit = NULL, interleave.random.points = 0L,
  filter.proposed.points = NULL, filter.proposed.points.tol = NULL,
  opt = "focussearch", opt.restarts = NULL, opt.focussearch.maxit = NULL,
  opt.focussearch.points = NULL, opt.cmaes.control = NULL,
  opt.ea.maxit = NULL, opt.ea.mu = NULL, opt.ea.sbx.eta = NULL,
  opt.ea.sbx.p = NULL, opt.ea.pm.eta = NULL, opt.ea.pm.p = NULL,
  opt.ea.lambda = NULL, opt.nsga2.popsize = NULL,
  opt.nsga2.generations = NULL, opt.nsga2.cprob = NULL,
  opt.nsga2.cdist = NULL, opt.nsga2.mprob = NULL, opt.nsga2.mdist = NULL)
}
\arguments{
\item{control}{[\code{\link{MBOControl}}]\cr
Control object for mbo.}

\item{crit}{[\code{\link{MBOInfillCrit}}]\cr
How should infill points be rated. See \code{\link{infillcrits}} for an overview
of available infill criteria or implement a custom one via \code{\link{makeMBOInfillCrit}}.#
Default is \dQuote{(lower) confidence bound} (see \code{\link{makeMBOInfillCritCB}}).}

\item{interleave.random.points}{[\code{integer(1)}]\cr
Add \code{interleave.random.points} uniformly sampled points additionally to the
regular proposed points in each step.
If \code{crit="random"} this value will be neglected.
Default is 0.}

\item{filter.proposed.points}{[\code{logical(1)}]\cr
Design points located too close to each other can lead to
numerical problems when using e.g. kriging as a surrogate model.
This may solve the 'leading minor of order ...' error during model fit.
This parameter activates or deactivates a heuristic to handle this issue.
If \code{TRUE}, proposed points whose distance to design points or other current
candidate points is smaller than \code{filter.proposed.points.tol}, are replaced by random points.
If enabled, the column entry for \code{prop.type} is set to \dQuote{random_filter} in the resulting \code{opt.path},
so you can see whether such a replacement happened.
This does only work for numeric parameter sets without any discrete parameters.
Default is \code{FALSE}.}

\item{filter.proposed.points.tol}{[\code{numeric(1)}]\cr
Tolerance value filtering of proposed points. We currently use a maximum metric
to calculate the distance between points.
Default is 0.0001.}

\item{opt}{[\code{character(1)}]\cr
How should SINGLE points be proposed by using the surrogate model. Possible values are:
\dQuote{focussearch}: In several iteration steps the parameter space is
focused on an especial promising region according to infill criterion.
\dQuote{cmaes}: Use CMA-ES (function \code{\link[cmaesr]{cmaes}} from package \pkg{cmaesr}
to optimize infill criterion. If all CMA-ES runs fail, a random point is generated
instead and a warning informs about it.
\dQuote{ea}: Use an (mu+1) EA to optimize infill criterion.
\dQuote{nsga2}: NSGA2 for multi obj. optimizations. Needed for mspot.
Default is \dQuote{focussearch}.
Alternatively, you may pass a function name as string.}

\item{opt.restarts}{[\code{integer(1)}]\cr
Number of independent restarts for optimizer of infill criterion.
If \code{opt == "cmaes"} the first start point for the optimizer is always the
currently best point in the design of already visited points. Subsequent starting
points are chosen according to the CMA-ES restart strategy introduced by Auger
and Hansen. For details see the corresponding paper in the references and the help
page of the underlying optimizer \code{\link[cmaesr]{cmaes}}.
Default is 3.}

\item{opt.focussearch.maxit}{[\code{integer(1)}]\cr
For \code{opt = "focussearch"}:
Number of iteration to shrink local focus.
Default is 5.}

\item{opt.focussearch.points}{[\code{integer(1)}]\cr
For \code{opt = "focussearch"}:
Number of points in each iteration of the focus search optimizer.
Default is 1000.}

\item{opt.cmaes.control}{[\code{list}]\cr
For \code{opt = "cmaes"}:
Control argument for cmaes optimizer.
For the default see the help page of the underlying optimizer \code{\link[cmaesr]{cmaes}}.}

\item{opt.ea.maxit}{[\code{integer(1)}]\cr
For \code{opt = "ea"}:
Number of iterations / generations of EA.
Default is 500.}

\item{opt.ea.mu}{[\code{integer(1)}]\cr
For \code{opt = "ea"}:
Population size of EA.
The default is 10 times the number of parameters of the function to optimize.}

\item{opt.ea.sbx.eta}{[\code{numeric(1)}]\cr
For \code{opt = "ea"}:
Distance parameter of crossover distribution , see \code{\link[emoa]{sbx_operator}}.
Default is 15.}

\item{opt.ea.sbx.p}{[\code{numeric(1)}]\cr
For \code{opt = "ea"}:
Probability of 1-point crossover, see \code{\link[emoa]{sbx_operator}}.
Default is 0.5.}

\item{opt.ea.pm.eta}{[\code{numeric(1)}]\cr
For \code{opt = "ea"}:
Distance parameter of mutation distribution, see \code{\link[emoa]{pm_operator}}.
Default is 15.}

\item{opt.ea.pm.p}{[\code{numeric(1)}]\cr
For \code{opt = "ea"}:
Probability of 1-point mutation, see \code{\link[emoa]{pm_operator}}.
Default is 0.5.}

\item{opt.ea.lambda}{[\code{numeric{1}}]\cr
For \code{opt.ea = "ea"}.
Number of children generated in each generation.
Default is 1.}

\item{opt.nsga2.popsize}{[\code{numeric{1}}]\cr
For \code{opt.multiobj.method = "nsga2"}.
Population size of nsga2.
Default is 100.}

\item{opt.nsga2.generations}{[\code{numeric{1}}]\cr
For \code{opt.multiobj.method = "nsga2"}.
Number of populations for of nsga2.
Default is 50.}

\item{opt.nsga2.cprob}{[\code{numeric{1}}]\cr
For \code{opt.multiobj.method = "nsga2"}.
nsga2 param. Default is 0.7.}

\item{opt.nsga2.cdist}{[\code{numeric{1}}]\cr
For \code{opt.multiobj.method = "nsga2"}.
nsga2 param. Default is 5.}

\item{opt.nsga2.mprob}{[\code{numeric{1}}]\cr
For \code{opt.multiobj.method = "nsga2"}.
nsga2 param. Default is 0.2.}

\item{opt.nsga2.mdist}{[\code{numeric{1}}]\cr
For \code{opt.multiobj.method = "nsga2"}.
nsga2 param. Default is 10.}
}
\value{
[\code{\link{MBOControl}}].
}
\description{
Please note that internally all infill criteria are minimized. So for some of them,
we internally compute their negated version, e.g., for EI or also for CB when the objective is to
be maximized. In the latter case mlrMBO actually computes the negative upper confidence bound and
minimizes that.
}
\seealso{
Other MBOControl: \code{\link{makeMBOControl}},
  \code{\link{setMBOControlMultiObj}},
  \code{\link{setMBOControlMultiPoint}},
  \code{\link{setMBOControlTermination}}
}
