% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setMBOControlTermination.R
\name{setMBOControlTermination}
\alias{setMBOControlTermination}
\title{Set termination options.}
\usage{
setMBOControlTermination(
  control,
  iters = NULL,
  time.budget = NULL,
  exec.time.budget = NULL,
  target.fun.value = NULL,
  max.evals = NULL,
  more.termination.conds = list(),
  use.for.adaptive.infill = NULL
)
}
\arguments{
\item{control}{[\code{\link{MBOControl}}]\cr
Control object for mbo.}

\item{iters}{[\code{integer(1)}]\cr
Number of sequential optimization steps.}

\item{time.budget}{[\code{numeric(1)} | NULL]\cr
Running time budget in seconds. Note that the actual mbo run can take more time since
the condition is checked after each iteration.
The default \code{NULL} means: There is no time budget.}

\item{exec.time.budget}{[\code{numeric(1)} | NULL]\cr
Execution time (time spent executing the function passed to \code{mbo})
budget in seconds. Note that the actual mbo run can take more time since
the condition is checked after each iteration.
The default \code{NULL} means: There is no execution time budget.}

\item{target.fun.value}{[\code{numeric(1)}] | NULL]\cr
Termination criterion for single-objective optimization: Stop if a function evaluation
is better than this given target.value.
The default \code{NULL} means: The function value won't be taken into account for termination.}

\item{max.evals}{[\code{integer(1) | NULL}]\cr
Maximal number of function evaluations.
The default \code{NULL} means: The total number of evaluations won't be taken into account for termination.}

\item{more.termination.conds}{[\code{list}]\cr
Optional list of termination conditions. Each condition needs to be a function
of a single argument \code{opt.state} of type \code{\link{OptState}} and should
return a list with the following elements:
\describe{
  \item{term [\code{logical(1)}]}{Logical value indicating whether the
  termination condition is met.}
  \item{message [\code{character(1)}]}{Termination message. At the moment we just allow \code{term.custom}.}
}}

\item{use.for.adaptive.infill}{[\code{character(1)}|NULL]\cr
Which termination criterion should determine the progress that is used for adaptive infill criteria like [\code{\link{makeMBOInfillCritAdaCB}}].
The default is \code{NULL} which means, that the first supplied argument is taken, following the order of the function signature.
Other values can be \code{"iters"}, \code{"time.budget"}, etc.\cr
If you want to to use it together with a criterion you supplied in \code{more.termination.conds}, \code{more.termination.conds} has to be a named list and the function further has to return a list element \code{progress} with values between 0 and 1.}
}
\value{
[\code{\link{MBOControl}}].
}
\description{
Extends an MBO control object with infill criteria and infill optimizer options.
}
\examples{
fn = smoof::makeSphereFunction(1L)
ctrl = makeMBOControl()

# custom termination condition (stop if target function value reached)
# We neglect the optimization direction (min/max) in this example.
yTargetValueTerminator = function(y.val) {
  force(y.val)
  function(opt.state) {
    opt.path = opt.state$opt.path
    current.best = getOptPathEl(opt.path, getOptPathBestIndex((opt.path)))$y
    term = (current.best <= y.val)
    message = if (!term) NA_character_ else sprintf("Target function value \%f reached.", y.val)
    return(list(term = term, message = message))
  }
}

# assign custom termination condition
ctrl = setMBOControlTermination(ctrl, more.termination.conds = list(yTargetValueTerminator(0.05)))
res = mbo(fn, control = ctrl)
print(res)
}
\seealso{
Other MBOControl: 
\code{\link{makeMBOControl}()},
\code{\link{setMBOControlInfill}()},
\code{\link{setMBOControlMultiObj}()},
\code{\link{setMBOControlMultiPoint}()}
}
\concept{MBOControl}
