% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{h_record_all_output}
\alias{h_record_all_output}
\title{Capture all Output}
\usage{
h_record_all_output(expr, remove = list())
}
\arguments{
\item{expr}{(\code{expression})\cr to be executed.}

\item{remove}{(\code{list})\cr optional list with elements \code{warnings}, \code{errors},
\code{messages} which can be character vectors, which will be removed from the
results if specified.}
}
\value{
A list containing
\itemize{
\item \code{result}: The object returned by \code{expr} or \code{list()} if an error was thrown.
\item \code{warnings}: \code{NULL} or a character vector if warnings were thrown.
\item \code{errors}: \code{NULL} or a string if an error was thrown.
\item \code{messages}: \code{NULL} or a character vector if messages were produced.
}
}
\description{
This function silences all warnings, errors & messages and instead returns a list
containing the results (if it didn't error) + the warning and error messages as
character vectors.
}
\keyword{internal}
