% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmb.R
\name{h_mmrm_tmb_data}
\alias{h_mmrm_tmb_data}
\title{Data for \code{TMB} Fit}
\usage{
h_mmrm_tmb_data(
  formula_parts,
  data,
  weights,
  reml,
  singular = c("drop", "error", "keep"),
  drop_visit_levels,
  allow_na_response = FALSE,
  drop_levels = TRUE,
  xlev = NULL,
  contrasts = NULL
)
}
\arguments{
\item{formula_parts}{(\code{mmrm_tmb_formula_parts})\cr list with formula parts
from \code{\link[=h_mmrm_tmb_formula_parts]{h_mmrm_tmb_formula_parts()}}.}

\item{data}{(\code{data.frame})\cr which contains variables used in \code{formula_parts}.}

\item{weights}{(\code{vector})\cr weights to be used in the fitting process.}

\item{reml}{(\code{flag})\cr whether restricted maximum likelihood (REML) estimation is used,
otherwise maximum likelihood (ML) is used.}

\item{singular}{(\code{string})\cr choices of method deal with rank-deficient matrices. "error" to
stop the function return the error, "drop" to drop these columns, and "keep" to keep all the columns.}

\item{drop_visit_levels}{(\code{flag})\cr whether to drop levels for visit variable, if visit variable is a factor.}

\item{allow_na_response}{(\code{flag})\cr whether NA in response is allowed.}

\item{drop_levels}{(\code{flag})\cr whether drop levels for covariates. If not dropped could lead to singular matrix.}
}
\value{
List of class \code{mmrm_tmb_data} with elements:
\itemize{
\item \code{full_frame}: \code{data.frame} with \code{n} rows containing all variables needed in the model.
\item \code{data}: \code{data.frame} of input dataset.
\item \code{x_matrix}: \code{matrix} with \code{n} rows and \code{p} columns specifying the overall design matrix.
\item \code{x_cols_aliased}: \code{logical} with potentially more than \code{p} elements indicating which
columns in the original design matrix have been left out to obtain a full rank
\code{x_matrix}.
\item \code{y_vector}: length \code{n} \code{numeric} specifying the overall response vector.
\item \code{weights_vector}: length \code{n} \code{numeric} specifying the weights vector.
\item \code{n_visits}: \code{int} with the number of visits, which is the dimension of the
covariance matrix.
\item \code{n_subjects}: \code{int} with the number of subjects.
\item \code{subject_zero_inds}: length \code{n_subjects} \code{integer} containing the zero-based start
indices for each subject.
\item \code{subject_n_visits}: length \code{n_subjects} \code{integer} containing the number of
observed visits for each subjects. So the sum of this vector equals \code{n}.
\item \code{cov_type}: \code{string} value specifying the covariance type.
\item \code{is_spatial_int}: \code{int} specifying whether the covariance structure is spatial(1) or not(0).
\item \code{reml}: \code{int} specifying whether REML estimation is used (1), otherwise ML (0).
\item \code{subject_groups}: \code{factor} specifying the grouping for each subject.
\item \code{n_groups}: \code{int} with the number of total groups
}
}
\description{
Data for \code{TMB} Fit
}
\details{
Note that the \code{subject_var} must not be factor but can also be character.
If it is character, then it will be converted to factor internally. Here
the levels will be the unique values, sorted alphabetically and numerically if there
is a common string prefix of numbers in the character elements. For full control
on the order please use a factor.
}
\keyword{internal}
