% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmb.R
\name{fit_mmrm}
\alias{fit_mmrm}
\title{Low-Level Fitting Function for MMRM}
\usage{
fit_mmrm(
  formula,
  data,
  weights,
  reml = TRUE,
  covariance = NULL,
  tmb_data,
  formula_parts,
  control = mmrm_control()
)
}
\arguments{
\item{formula}{(\code{formula})\cr model formula with exactly one special term
specifying the visits within subjects, see details.}

\item{data}{(\code{data.frame})\cr input data containing the variables used in
\code{formula}.}

\item{weights}{(\code{vector})\cr input vector containing the weights.}

\item{reml}{(\code{flag})\cr whether restricted maximum likelihood (REML) estimation is used,
otherwise maximum likelihood (ML) is used.}

\item{covariance}{(\code{cov_struct})\cr A covariance structure type definition,
or value that can be coerced to a covariance structure using
\code{\link[=as.cov_struct]{as.cov_struct()}}. If no value is provided, a structure is derived from
the provided formula.}

\item{tmb_data}{(\code{mmrm_tmb_data})\cr object.}

\item{formula_parts}{(\code{mmrm_tmb_formula_parts})\cr list with formula parts
from \code{\link[=h_mmrm_tmb_formula_parts]{h_mmrm_tmb_formula_parts()}}.}

\item{control}{(\code{mmrm_control})\cr list of control options produced by
\code{\link[=mmrm_control]{mmrm_control()}}.}
}
\value{
List of class \code{mmrm_tmb}, see \code{\link[=h_mmrm_tmb_fit]{h_mmrm_tmb_fit()}} for details.
In addition, it contains elements \code{call} and \code{optimizer}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This is the low-level function to fit an MMRM. Note that this does not
try different optimizers or adds Jacobian information etc. in contrast to
\code{\link[=mmrm]{mmrm()}}.
}
\details{
The \code{formula} typically looks like:

\code{FEV1 ~ RACE + SEX + ARMCD * AVISIT + us(AVISIT | USUBJID)}

which specifies response and covariates as usual, and exactly one special term
defines which covariance structure is used and what are the visit and
subject variables.

Always use only the first optimizer if multiple optimizers are provided.
}
\examples{
formula <- FEV1 ~ RACE + SEX + ARMCD * AVISIT + us(AVISIT | USUBJID)
data <- fev_data
system.time(result <- fit_mmrm(formula, data, rep(1, nrow(fev_data))))
}
