% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnis_eligible.R
\name{mnis_eligible}
\alias{mnis_eligible}
\title{mnis_eligible}
\usage{
mnis_eligible(eligible = TRUE, house = "all", party = NULL, tidy = TRUE)
}
\arguments{
\item{eligible}{If the member is currently eligible to sit. Accepts TRUE or FALSE. Defaults to TRUE.}

\item{house}{The house to which the member belongs. Accepts one of 'all', 'lords' and 'commons', defaults to 'all'.}

\item{party}{The party to which a member belongs. Defaults to NULL.}

\item{tidy}{Fix the variable names in the data frame to remove special characters and superfluous text, and converts the variable names to all lower case with underscores between each word. Defaults to TRUE.}
}
\description{
Function returns all members who took their seats in the house between two given dates. The function requests data in JSON format and parses it to a data frame.
}
\examples{
\dontrun{
x <- mnis_eligible(eligible='all', house='all', party='labour')

}
}
\keyword{mnis}
