% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viewing_distance_correction.R
\name{logMARcorrect}
\alias{logMARcorrect}
\title{Print size correction for non-standard viewing distance}
\usage{
logMARcorrect(data, print_size, viewing_distance)
}
\arguments{
\item{data}{The name of your dataframe}

\item{print_size}{The variable that contains print size values (print size uncorrected for viewing distance)}

\item{viewing_distance}{The variable that contains the viewing distance value used for testing}
}
\value{
The function returns the original dataframe with an added variable called "correct_ps" that contains corrected print size values (in logMAR).
}
\description{
The logMAR scale allows simple conversion of print size between different viewing distances.
When the MNREAD test is not run at the standard distance (ie. 40 cm - 16 inches),
the angular print size (in logMAR) must be adjusted to compensate for the change in viewing distance.
This function allows to correct the print size accordingly to the viewing distance used for testing.
}
\examples{
# inspect the strucutre of the dataframe
head(data_low_vision, 10)

# run the correction
data_low_vision_new <- logMARcorrect(data_low_vision, ps, vd)

# inspect the structure of the newly created dataframe
head(data_low_vision_new, 10)

}
