% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.mf.object.lm.R
\name{get.mf.object.lm}
\alias{get.mf.object.lm}
\title{Fit a linear model to a mobForest model}
\usage{
get.mf.object.lm(object, main_model, partition_vars, data, new_test_data, ntree,
  fam)
}
\arguments{
\item{object}{A bootstrap model object created by \link[=bootstrap]{bootstrap()}}

\item{main_model}{A model in character format.}

\item{partition_vars}{A vector of partition variables.}

\item{data}{A data frame containing the variables in the model.}

\item{new_test_data}{A data frame representing test data for validating
random forest model. This data is not used in in tree building process.}

\item{ntree}{Number of trees to be constructed in forest (default = 300)}

\item{fam}{A description of error distribution and link function to be used
in the model. This parameter needs to be specified if generalized linear
model is considered. The parameter "binomial()" is to be specified
when logistic regression is considered and "poisson()" when Poisson
regression is considered as the node model. The values allowed for this
parameter are binomial() and poisson().}
}
\value{
An object of class \code{\linkS4class{mobforest.output}}.
}
\description{
This method computes predicted outcome for each observation in the data
frame using the tree model supplied as an input argument.
}
\seealso{
\link[=mobforest.control]{mobforest.control()},
\code{\link{mobforest.output-class}}
}
