% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modcmfitrFunctions.R
\name{fitDirichlet}
\alias{fitDirichlet}
\title{Fit Dirichlet distribution}
\usage{
fitDirichlet(Outcomes, RawData, SearchParams, Quantiles)
}
\arguments{
\item{Outcomes}{A vector of names of outcomes}

\item{RawData}{matrix of lower, middle and upper quantiles for each dimension elicited from experts}

\item{SearchParams}{A vector of number of iterations and max number of searches.
Number of iterations is the number of draws from the mCM distribution used to estimate the quantiles.  Try 10,000 first.
Max number of searches is the maximum number of searches the search algorithm conducts.  The higher the better the solution, but also the longer it takes.  Try 1000 first.}

\item{Quantiles}{Sets the quantiles to be fit.  If median and 95\% Credibility Intervals, then set to c(0.025,0.5,0.975).  If median and tertiles then c(0.33,0.5,0.66).  If median and quartiles then c(0.25,0.5,0.75) and so on.}
}
\value{
Returns a matrix, each row representing one of the Outcomes.  Column 'Dirichlet' is the parameters of the Dirichlet distribution.  
The next three columns (Tgt_LL, Tgt_MED, Tgt_UL) are the target quantiles input to the function as 'RawData' in the example above.
The final three (Mdl_LL, Mdl_MED, Mdl_UL) are the quantiles resulting from the model fitting.  If the mCM is a good fit, the Mdl columns will be 
identical to the Tgt columns.
}
\description{
This function fits a Dirichlet distribution to an elicited set of quantiles from, e.g. an expert elicitation workshop.
The function uses the crs2lm() function from the nloptr package to search for the
set of hyperparameters that that generates quantiles that match the elicited data as closely as possible.
crs2lm() repeatedly calls TestFitDirichlet() until it finds the best fitting set of inputs.
The function returns a data frame containing the best fit set of hyperparameters of the Dirichlet, the Target quantiles and the modelled quantiles.
}
\examples{
Outcomes <- c("Remission","Progression","Dead")
RawData <- matrix(data = c(0.43, 0.55, 0.65,
                          0.16, 0.27, 0.46,
                          0.03, 0.18, 0.23
           ),ncol=3,byrow=TRUE)

SearchParams <- c(10000,100) #number of iterations, max number of searches

Quantiles <- c(0.025,0.5,0.975) # example here is 95\% credibility limits and median.

fitDirichlet(Outcomes, RawData, SearchParams, Quantiles)
}
\keyword{Dirichlet}
