% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvlldiff.R
\name{cvlldiff}
\alias{cvlldiff}
\title{Cross-Validated Difference in Means (CVDM) Test with Vector Imputs}
\usage{
cvlldiff(vector1, vector2, df)
}
\arguments{
\item{vector1}{A numeric vector of cross-validated log-likelihoods.}

\item{vector2}{A numeric vector of cross-validated log-likelihoods.}

\item{df}{A value of the degrees of freedom in the models.}
}
\value{
An object of class \code{cvlldiff} computed by the cross-validated log likelihood
difference in means test (CVDM). The test statistic object is the Cross-Validated
Johnson's t-test. A positive test statistic supports the first method and a negative test
statistic supports the second.See \code{\link{cvdm_object}} for more details.
}
\description{
Applies cross-validated log-likelihood to test between
two methods of estimating a formula. The output identifies the vector
from the more appropriate model.

Please cite:

Desmarais, B. A., & Harden, J. J. (2014). An Unbiased Model Comparison Test Using
Cross-Validation. Quality & Quantity, 48(4), 2155-2173.
\href{https://doi.org/10.1007/s11135-013-9884-7}{https://doi.org/10.1007/s11135-013-9884-7}
}
\details{
This function implements the cross-validated difference in means (CVDM)
test between two vectors of cross-validated log-likelihoods. A positive test
statistic supports the method that produced the first vector and a negative
test statistic supports the second.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}
\donttest{
  set.seed(123456)
  b0 <- .2 # True value for the intercept
  b1 <- .5 # True value for the slope
  n <- 500 # Sample size
  X <- runif(n, -1, 1)

  Y <- b0 + b1 * X + rnorm(n, 0, 1) # N(0, 1 error)
  cvll_ols <- cvll(Y ~ X, data.frame(cbind(Y, X)), method = "OLS")
  cvll_mr <- cvll(Y ~ X, data.frame(cbind(Y, X)), method = "MR")
  obj_compare <- cvlldiff(cvll_ols$cvll, cvll_mr$cvll, cvll_ols$df)
}
\dontshow{setwd(.old_wd)}
}
\references{
Desmarais, B. A., & Harden, J. J. (2014). An Unbiased Model Comparison Test Using
Cross-Validation. Quality & Quantity, 48(4), 2155-2173.
\href{https://doi.org/10.1007/s11135-013-9884-7}{https://doi.org/10.1007/s11135-013-9884-7}
}
