% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/A06_modelObj.R, R/A07_modelObjFormula.R,
%   R/A08_modelObjXY.R
\docType{class}
\name{modelObj}
\alias{modelObj}
\alias{modelObjFormula-class}
\alias{modelObjXY-class}
\title{Class \code{modelObj}}
\description{
A class for model objects.
}
\details{
Objects should not be created directly. The utility function
buildModelObj() should be used.
}
\section{Slots}{

\describe{
\item{\code{model}}{Object of class \code{formula}}

\item{\code{solver}}{Object of class \code{methodObjSolver} method to obtain 
parameter estimates.}

\item{\code{predictor}}{Object of class \code{methodObjPredict} method to obtain 
predicted values.}
}}

\section{Methods}{

  \describe{
    \item{fit}{: Executes regression step. }
    \item{model}{: Retrieve model. }
    \item{solver}{: Retrieve regression method name. }
    \item{solverArgs}{: Retrieve arguments to be sent to regression method. }
    \item{solverArgs(object)<-}{: Set arguments to be sent to regression method. }
    \item{predictor}{: Retrieve prediction method name. }
    \item{predictorArgs}{: Retrieve arguments to be sent to prediction method. }
    \item{predictorArgs(object)<-}{: Set arguments to be sent to prediction method. }
  }
}

\examples{
showClass("modelObj")

}
