#' Solubility predictions from MARS model
#'
#' @details For the solubility data in Kuhn and Johnson (2013),
#'  these data are the test set results for the MARS model. The
#'  observed solubility (in column `solubility`) and the model
#'  results (`prediction`) are contained in the data.
#'
#' @name solubility_test
#' @aliases solubility_test
#' @docType data
#' @return \item{solubility_test}{a data frame}
#'
#' @source Kuhn, M., Johnson, K. (2013) *Applied Predictive
#'  Modeling*, Springer
#'
#' @keywords datasets
#' @examples
#' data(solubility_test)
#' str(solubility_test)
NULL
