% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_model_engine.R
\name{set_model_engine}
\alias{set_model_engine}
\title{Register Engine for Model}
\usage{
set_model_engine(model, mode, eng)
}
\arguments{
\item{model}{A single character string for the model type (e.g. "k_means",
etc).}

\item{mode}{A single character string for the model mode (e.g. "partition").}

\item{eng}{A single character string for the model engine.}
}
\value{
NULL invisibly
}
\description{
This function is used to register a mode for a model and mode combination.
}
\details{
This function will error if called multiple times with the same arguments. As
you should only have one unique model, mode, eng combination.
}
\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
set_new_model("shallow_learning_model")
set_model_mode("shallow_learning_model", "partition")

get_from_env("shallow_learning_model")

set_model_engine("shallow_learning_model", "partition", "stats")

get_from_env("shallow_learning_model")
\dontshow{\}) # examplesIf}
}
