% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_model.R
\name{add_model}
\alias{add_model}
\title{Add a model specification to a model grid}
\usage{
add_model(model_grid, model_name = NULL, custom_control = NULL, ...)
}
\arguments{
\item{model_grid}{\code{model_grid}}

\item{model_name}{\code{character}, your custom name for a given model. Must be
unique within the model grid. If you do not provide a name, the model will be
given a generic name - 'Model[int]'.}

\item{custom_control}{\code{list}, any customization to subsettings of the 'trControl'
component from the 'shared_settings' of the model grid (will only work if
trControl' parameter has actually been set as part of the shared settings).}

\item{...}{All (optional) individual settings (including model training settings)
that the user wishes to set for the new model.}
}
\value{
\code{model_grid} with an additional individual model specification.
}
\description{
Define and add an individual model (and model training) specification to an
existing model grid.
}
\examples{
library(magrittr)

# Pre-allocate empty model grid.
mg <- model_grid()

# Add 'random forest' model spec.
mg <-
  mg \%>\%
  add_model(model_name = "Random Forest Test", method = "rf", tuneLength = 5)
}
