% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numbers_math.R
\name{ldgamma.modello_number}
\alias{ldgamma.modello_number}
\alias{ldgamma.default}
\alias{ldgamma}
\title{Gamma Distribution: log-density}
\usage{
\method{ldgamma}{modello_number}(y, a, b)

\method{ldgamma}{default}(y, a, b)

ldgamma(y, a, b)
}
\arguments{
\item{y}{observations, numeric or reference object of class 'number'}

\item{a}{shape parameter, numeric of reference object of class 'number'}

\item{b}{rate parameter, numeric of reference object of class 'number'}
}
\value{
Returns a 'numeric' or a reference object of class 'number'
}
\description{
Considering a Gamma Distribution calculates the log-density.
\deqn{\alpha * log(\beta) - logGamma(\alpha) + (\alpha - 1) log(y) - \beta * y; y > 0}
}
\examples{
modello.init()
## For modello_numbers
y = number(rgamma(10, 5, 4))
ld = ldgamma(y, .k(5), .k(4))
print(ld)
print(ld$v)
modello.close()
## For numerics
y = rgamma(10, 5, 4)
ld = ldgamma(y, 5, 4)
print(ld) 
}
\author{
Filippo Monari
}
