% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_gof.R
\name{extract_gof}
\alias{extract_gof}
\title{Extract goodness-of-fit statistics from a single model}
\usage{
extract_gof(model, fmt, gof_map, ...)
}
\arguments{
\item{model}{object type with an available `glance` method.}

\item{fmt}{string which specifies how numeric values will be rounded. This
string is passed to the `sprintf` function. '\%.3f' will keep 3 digits after
the decimal point with trailing zero. '\%.5f' will keep 5 digits. '\%.3e' will
use exponential notation. See `?sprintf` for more options.}

\item{gof_map}{data.frame with four columns: `raw`, `clean`, `fmt`, and
`omit`. If `gof_map` is NULL, then `modelsummary` will use this data frame
by default: `modelsummary::gof_map`}

\item{...}{all other arguments are passed to the `tidy` method used to
extract estimates from the model. For example, this allows users to set
`exponentiate=TRUE` to exponentiate logistic regression coefficients.}
}
\value{
tibble with goodness-of-fit  statistics
}
\description{
Extract goodness-of-fit statistics from a single model
}
\keyword{internal}
