% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof_map.R
\docType{data}
\name{gof_map}
\alias{gof_map}
\title{Data.frame used to clean up and format goodness-of-fit statistics}
\format{
data.frame with 4 columns of character data: raw, clean, fmt, omit
}
\usage{
gof_map
}
\description{
By default, this data frame is passed to the 'gof_map' argument of the
'msummary' or 'modelsummary' functions. Users can modify this data frame to
customize the list of statistics to display and their format. See example
below.
}
\examples{
\dontrun{

library(modelsummary)
mod <- lm(wt ~ drat, data = mtcars)
gm <- modelsummary::gof_map
gm$omit[gm$raw == 'deviance'] <- FALSE
gm$fmt[gm$raw == 'r.squared'] <- "\%.5f"
msummary(mod, gof_map = gm)

} 
}
\keyword{datasets}
