% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment_data_helper.R
\name{augment_data_helper}
\alias{augment_data_helper}
\title{Get copies of a dataset with various rowname behaviors}
\usage{
augment_data_helper(data, add_missing)
}
\arguments{
\item{data}{A data set as a \code{data.frame} or \code{tibble}.}

\item{add_missing}{Whether or not to set some values in \code{data} to \code{NA}.
When \code{TRUE} sets the diagonal elements of \code{data} to \code{NA} and adds a
row of all \code{NA}s to the end of data. This ensures that every column
has missing data. Defaults to \code{FALSE}.}
}
\value{
A list with three copies of \code{data}:
\itemize{
\item \strong{tibble}: the data in a \code{\link[tibble:tibble]{tibble::tibble()}}.
\item \strong{no_row}: the data in a \code{\link[=data.frame]{data.frame()}} without row names.
\item \strong{row_nm}: the data in a \code{data.frame}, with row names.
}
}
\description{
Helper function for \code{\link[=check_augment_data_specification]{check_augment_data_specification()}}. There should be no need
to ever use this directly in tests. Takes a dataset and returns a list
with three copies of the dataset. Optionally introduces \code{NA} values into
the dataset. Useful for checking that tibbles, data frames, and data frames with
rownames are treated equivalently.
}
\seealso{
\code{\link[=.row_names_info]{.row_names_info()}}, \code{\link[=rownames]{rownames()}}, \code{\link[tibble:rownames_to_column]{tibble::rownames_to_column()}}
}
\keyword{internal}
