% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-resamples.R
\name{unnest_modeltime_resamples}
\alias{unnest_modeltime_resamples}
\title{Unnests the Results of Modeltime Fit Resamples}
\usage{
unnest_modeltime_resamples(object)
}
\arguments{
\item{object}{A Modeltime Table that has a column '.resample_results'}
}
\value{
Tibble with columns for '.row_id', '.resample_id', '.model_id', '.model_desc', '.pred',
'.row', and actual value name from the data set
}
\description{
An internal function used by \code{\link[=modeltime_resample_accuracy]{modeltime_resample_accuracy()}}.
}
\details{
The following data columns are unnested and prepared for evaluation:
\itemize{
\item \code{.row_id} - A unique identifier to compare observations.
\item \code{.resample_id} - A unique identifier given to the resample iteration.
\item \code{.model_id} and \code{.model_desc} - Modeltime Model ID and Description
\item \code{.pred} - The Resample Prediction Value
\item \code{.row} - The actual row value from the original dataset
\item \emph{Actual Value Column} - The name changes to target variable name in dataset
}
}
\examples{

# The .resample_results column is deeply nested
m750_training_resamples_fitted

# Unnest and prepare the resample predictions for evaluation
unnest_modeltime_resamples(m750_training_resamples_fitted)

}
