% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeltime-table.R
\name{modeltime_table}
\alias{modeltime_table}
\alias{as_modeltime_table}
\title{Scale forecast analysis with a Modeltime Table}
\usage{
modeltime_table(...)

as_modeltime_table(.l)
}
\arguments{
\item{...}{Fitted \code{parsnip} model or \code{workflow} objects}

\item{.l}{A list containing fitted \code{parsnip} model or \code{workflow} objects}
}
\description{
Designed to perform forecasts at scale using models created with
\code{modeltime}, \code{parsnip}, \code{workflows}, and regression modeling extensions
in the \code{tidymodels} ecosystem.
}
\details{
\code{modeltime_table()}:
\enumerate{
\item Creates a table of models
\item Validates that all objects are models (parsnip or workflows objects) and
all models have been fitted (trained)
\item Provides an ID and Description of the models
}

\code{as_modeltime_table()}:

Converts a \code{list} of models to a modeltime table. Useful if programatically creating
Modeltime Tables from models stored in a \code{list}.
}
\examples{
library(tidyverse)
library(lubridate)
library(timetk)
library(parsnip)
library(rsample)

# Data
m750 <- m4_monthly \%>\% filter(id == "M750")

# Split Data 80/20
splits <- initial_time_split(m750, prop = 0.9)

# --- MODELS ---

# Model 1: auto_arima ----
model_fit_arima <- arima_reg() \%>\%
    set_engine(engine = "auto_arima") \%>\%
    fit(value ~ date, data = training(splits))


# ---- MODELTIME TABLE ----

# Make a Modeltime Table
models_tbl <- modeltime_table(
    model_fit_arima
)

# Can also convert a list of models
list(model_fit_arima) \%>\%
    as_modeltime_table()

# ---- CALIBRATE ----

calibration_tbl <- models_tbl \%>\%
    modeltime_calibrate(new_data = testing(splits))

# ---- ACCURACY ----

calibration_tbl \%>\%
    modeltime_accuracy()

# ---- FORECAST ----

calibration_tbl \%>\%
    modeltime_forecast(
        new_data    = testing(splits),
        actual_data = m750
    )

}
