% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsnip-arima_reg.R
\name{auto_arima_fit_impl}
\alias{auto_arima_fit_impl}
\title{Low-Level ARIMA function for translating modeltime to forecast}
\usage{
auto_arima_fit_impl(
  x,
  y,
  period = "auto",
  max.p = 5,
  max.d = 2,
  max.q = 5,
  max.P = 2,
  max.D = 1,
  max.Q = 2,
  ...
)
}
\arguments{
\item{x}{A dataframe of xreg (exogenous regressors)}

\item{y}{A numeric vector of values to fit}

\item{period}{A seasonal frequency. Uses "auto" by default. A character phrase
of "auto" or time-based phrase of "2 weeks" can be used if a date or date-time variable is provided.}

\item{max.p}{The maximum order of the non-seasonal auto-regressive (AR) terms.}

\item{max.d}{The maximum order of integration for non-seasonal differencing.}

\item{max.q}{The maximum order of the non-seasonal moving average (MA) terms.}

\item{max.P}{The maximum order of the seasonal auto-regressive (SAR) terms.}

\item{max.D}{The maximum order of integration for seasonal differencing.}

\item{max.Q}{The maximum order of the seasonal moving average (SMA) terms.}

\item{...}{Additional arguments passed to \code{forecast::auto.arima}}
}
\description{
Low-Level ARIMA function for translating modeltime to forecast
}
\keyword{internal}
